/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.utils;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.PETrace;
import com.ibm.hwmca.xfw.service.utils.PBLogErrorMessage;
import com.ibm.hwmca.xfw.service.utils.PBLogInfoMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RVCommonLogging {
    private static final String TRACE_MASKT = "XRVXLOGT";
    private static final String TRACE_MASKF = "XRVXLOGF";
    private static final String TRACE_MASKD = "XRVXLOGD";
    public static final int XRV_NO_ERROR = 0;
    public static final int XRV_COMP_RC_SET = 2;
    public static final int XRV_LOG_ISSUED = 8;
    public static final char XRV_BASE_A2 = 'A';
    public static final char XRV_PROC_38 = '3';
    public static final char XRV_LOG_INFORMATIONAL = 'I';
    public static final char XRV_LOG_ERROR = 'E';
    private static final FrameworkClassLogInfo classA2Error = new FrameworkClassLogInfo(-94, "RV_BaseErr");
    private static final FrameworkClassLogInfo class38Error = new FrameworkClassLogInfo(56, "RV_ProcErr");
    private static final byte XLOG_RVEND = 8;
    private static final byte XLOG_RVDELAY = 10;
    private static final byte XLOG_RVREPLAC = 13;
    private static final byte XLOG_RVRECREA = 14;
    private static final byte XLOG_RVEXTISO = 17;
    private static final byte XLOG_RVPANTRC = 25;
    private static final byte XLOG_RVCOMBO = 32;
    private static final byte XLOG_RVVALID = 33;
    private static final byte EXCHANGE_TEXT_BLOCK = 1;
    public static short XRV_LOG_260E = (short)9742;
    public static short XRV_LOG_260F = (short)9743;
    public static final short XRV_LOG_RVSTART = 1;
    public static final short XRV_LOG_RVEND = 2;
    public static final short XRV_LOG_RVDELAY = 3;
    public static final short XRV_LOG_RVREPLAC = 4;
    public static final short XRV_LOG_RVVALIDATE = 6;
    public static final short XRV_LOG_RVEXTISO = 7;
    public static final short XRV_LOG_RVSHCLOS = 8;
    public static final short XRV_LOG_RVSHNEWD = 9;
    public static final short XRV_LOG_RVCOMBO = 10;
    public static final short XRV_LOG_RVCANCEL = 11;
    public static final short XRV_LOG_REPORT_REP = 12;
    public static final short XRV_LOG_ADD_REPAIR = 13;
    public static final short XRV_LOG_CPNLEN = 5;

    public void RVCommonLogging() {
    }

    public static int logAvailableTraceInfo(String message, Throwable exception, Map userData) {
        return RVCommonLogging.logError('3', 'I', 0, (short)0, 0, exception, message, message, userData);
    }

    public static int logAvailableTraceInfo(String message) {
        return RVCommonLogging.logAvailableTraceInfo(message, null, null);
    }

    public static int logAvailableTraceInfo(String message, Map userData) {
        return RVCommonLogging.logAvailableTraceInfo(message, null, userData);
    }

    public static int logAvailableTraceInfo(String message, Throwable exception) {
        return RVCommonLogging.logAvailableTraceInfo(message, exception, null);
    }

    public static int logError(char logType, char action, int sysRc, short errorId, int errorReason, Throwable exception, String endTrace, String debugMessage, Map userData) {
        short user = 0;
        int iSystemRc = 0;
        GenericGui guiHandle = null;
        if (userData != null) {
            PETrace.petrace(userData, TRACE_MASKT, "-> RVCommonLogging.logError");
            PETrace.petrace(userData, TRACE_MASKF, "   Input data:");
            PETrace.petrace(userData, TRACE_MASKF, "    logType " + logType);
            PETrace.petrace(userData, TRACE_MASKF, "    action " + action);
            PETrace.petrace(userData, TRACE_MASKF, "    sysRc " + sysRc);
            PETrace.petrace(userData, TRACE_MASKF, "    errorId " + errorId);
            PETrace.petrace(userData, TRACE_MASKF, "    errorReason " + errorReason);
            if (debugMessage != null) {
                PETrace.petrace(userData, TRACE_MASKF, "    debugMessage " + debugMessage);
            }
        } else {
            Trace.trace(TRACE_MASKT, "-> RVCommonLogging.logError null userData");
            Trace.trace(TRACE_MASKF, "   Input data:");
            Trace.trace(TRACE_MASKF, "    logType " + logType);
            Trace.trace(TRACE_MASKF, "    action " + action);
            Trace.trace(TRACE_MASKF, "    sysRc " + sysRc);
            Trace.trace(TRACE_MASKF, "    errorId " + errorId);
            Trace.trace(TRACE_MASKF, "    errorReason " + errorReason);
            if (debugMessage != null) {
                Trace.trace(TRACE_MASKF, "    debugMessage " + debugMessage);
            }
        }
        FrameworkLog log = logType == '3' ? new FrameworkLog(class38Error, user, errorId, errorReason, exception) : new FrameworkLog(classA2Error, user, errorId, errorReason, exception);
        if (userData != null) {
            guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
        }
        iSystemRc = sysRc;
        switch (action) {
            case 'E': {
                if (iSystemRc >= 8) break;
                log.log((LogAttributes)MicrocodeLogAttributes.ERROR_LOG);
                iSystemRc = 8;
                if (userData == null) break;
                PBLogErrorMessage logErrorMsgBean = new PBLogErrorMessage();
                HashMap<String, String> hmTemp = new HashMap<String, String>();
                if (debugMessage != null) {
                    hmTemp.put("debug_message", debugMessage);
                } else {
                    hmTemp.put("debug_message", "");
                }
                logErrorMsgBean.setDataMap(hmTemp);
                try {
                    logErrorMsgBean = (PBLogErrorMessage)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", logErrorMsgBean.getTemplateName(), logErrorMsgBean, userData);
                }
                catch (Exception e) {
                    PETrace.petrace(userData, TRACE_MASKF, "    displayHandle.replace exception caught: " + e);
                    PETrace.petrace(userData, e);
                }
                break;
            }
            default: {
                log.log((LogAttributes)MicrocodeLogAttributes.INFO_LOG);
                if (userData == null) break;
                PBLogInfoMessage logInfoMsgBean = new PBLogInfoMessage();
                HashMap<String, String> hmTemp = new HashMap<String, String>();
                if (debugMessage != null) {
                    hmTemp.put("debug_message", debugMessage);
                } else {
                    hmTemp.put("debug_message", "");
                }
                logInfoMsgBean.setDataMap(hmTemp);
                try {
                    logInfoMsgBean = (PBLogInfoMessage)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", logInfoMsgBean.getTemplateName(), logInfoMsgBean, userData);
                }
                catch (Exception e) {
                    PETrace.petrace(userData, TRACE_MASKF, "    displayHandle.replace exception caught: " + e);
                    PETrace.petrace(userData, e);
                }
                break;
            }
        }
        if (userData != null) {
            PETrace.petrace(userData, TRACE_MASKT, "<- RVCommonLogging.logError");
            if (endTrace != null) {
                PETrace.petrace(userData, TRACE_MASKT, endTrace);
            }
        } else {
            Trace.trace(TRACE_MASKT, "<- RVCommonLogging.logError null userData");
            if (endTrace != null) {
                Trace.trace(TRACE_MASKF, endTrace);
            }
        }
        return iSystemRc;
    }

    public static int logEvent(short symName, Map userData) {
        boolean logType = false;
        short user = 0;
        int iSystemRc = 0;
        String endTrace = "<- RVCommonLogging.logEvent";
        PETrace.petrace(userData, TRACE_MASKT, "-> RVCommonLogging.logEvent");
        PETrace.petrace(userData, TRACE_MASKF, "   Input data:");
        PETrace.petrace(userData, TRACE_MASKF, "    symName " + symName);
        Date date = new Date();
        switch (symName) {
            case 1: {
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History repair start");
                RVCommonLogging.logServiceHistory((byte)4, userData);
                break;
            }
            case 3: {
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History repair delay");
                RVCommonLogging.logServiceHistory((byte)5, userData);
                break;
            }
            case 9: {
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History new data for repair");
                RVCommonLogging.logServiceHistory((byte)12, userData);
                break;
            }
            case 8: {
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History problem close");
                RVCommonLogging.logServiceHistory((byte)32, userData);
                break;
            }
            case 2: {
                PETrace.petrace(userData, TRACE_MASKF, " logging RV end");
                Log endLog = new Log(15, 8, user, "REPAIR_END", date, null, null, null);
                endLog.log();
                PETrace.petrace(userData, TRACE_MASKF, " logged RV end");
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History repair ended");
                RVCommonLogging.logServiceHistory((byte)9, userData);
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History problem closed");
                RVCommonLogging.logServiceHistory((byte)32, userData);
                break;
            }
            case 4: {
                Log exchLog = new Log(15, 13, user, "RV_EXCHANGE", date, null, null, null);
                CommonProblem cp = (CommonProblem)userData.get("PROBLEM");
                StringBuffer logBuffer = new StringBuffer();
                List fruList = (List)userData.get("FRU_LIST");
                Iterator it = fruList.iterator();
                while (it.hasNext()) {
                    ServiceableElement fru = (ServiceableElement)it.next();
                    logBuffer.append(cp.getProblemNumber());
                    logBuffer.append("  ");
                    logBuffer.append(fru.getProperty("LOCATION"));
                    logBuffer.append("  ");
                    logBuffer.append("  ");
                    logBuffer.append("new");
                    if (logBuffer.length() > 0) {
                        String logData = logBuffer.toString();
                        exchLog.add((byte)1, logData);
                    }
                    exchLog.log();
                }
                break;
            }
            case 6: {
                PETrace.petrace(userData, TRACE_MASKF, " logging RV validate");
                Log validLog = new Log(15, 33, user, "RV_VERIFY", date, null, null, null);
                break;
            }
            case 7: {
                PETrace.petrace(userData, TRACE_MASKF, " logging RV isolate");
                Log isolateLog = new Log(15, 17, user, "RV_ISOLATE", date, null, null, null);
                isolateLog.log();
                break;
            }
            case 10: {
                PETrace.petrace(userData, TRACE_MASKF, " logging RV combo");
                Log comboLog = new Log(15, 32, user, "RV_COMBO", date, null, null, null);
                comboLog.log();
                break;
            }
            case 11: {
                PETrace.petrace(userData, TRACE_MASKF, " logging Service History RV cancel");
                RVCommonLogging.logServiceHistory((byte)19, userData);
                break;
            }
            default: {
                return RVCommonLogging.logError('A', 'E', iSystemRc, XRV_LOG_260E, 0, null, null, null, userData);
            }
        }
        PETrace.petrace(userData, TRACE_MASKT, "<- RVCommonLogging.logEvent");
        return iSystemRc;
    }

    private static void logServiceHistory(byte state, Map userData) {
        switch (state) {
            case 4: {
                break;
            }
            case 8: {
                break;
            }
        }
        HistoryEntry entry = new HistoryEntry(state);
        CommonProblem cp = (CommonProblem)userData.get("PROBLEM");
        try {
            cp.addHistory(entry);
        }
        catch (ProblemNotRegisteredException pnre) {
            PETrace.petrace(userData, TRACE_MASKF, "    addHistory ProblemNotRegisteredException caught: " + pnre);
            PETrace.petrace(userData, pnre);
        }
        catch (PersistenceNotInitializedException pnie) {
            PETrace.petrace(userData, TRACE_MASKF, "    addHistory ProblemNotInitializedException caught: " + pnie);
            PETrace.petrace(userData, pnie);
        }
        catch (ProblemPersistenceException ppe) {
            PETrace.petrace(userData, TRACE_MASKF, "    addHistory ProblemPersistenceException caught: " + ppe);
            PETrace.petrace(userData, ppe);
        }
    }
}

